import 'package:rad/rad.dart';

import 'package:photogram_admin_cp/import/bloc.dart';
import 'package:photogram_admin_cp/import/core.dart';
import 'package:photogram_admin_cp/import/data.dart';

import 'package:photogram_admin_cp/ui/components/util_widgets.dart';

class PreparingScreen extends StatefulWidget {
  final AdminModel authedAdmin;

  const PreparingScreen({
    Key? key,
    required this.authedAdmin,
  }) : super(key: key);

  @override
  _PreparingScreenState createState() => _PreparingScreenState();
}

class _PreparingScreenState extends State<PreparingScreen> with AppActiveContentMixin {
  @override
  onLoadEvent() {
    Future.delayed(Duration.zero, _fetchSettings);
  }

  @override
  void dispose() {
    // prevent resources from getting disposed as this screen is meant to prepare
    // resources for other parts of system.
  }

  @override
  build(context) {
    return UtilWidgets.preloader('Fetching resources...');
  }

  void _fetchSettings() async {
    var responseModel = await activeContent.apiRepository.preparedRequest(
      requestType: REQ_TYPE_ADMIN_SETTINGS_LOAD,
      requestData: {},
    );

    activeContent.handleResponse(responseModel);

    AuthBloc.of(context).pushEvent(
      AuthEventSetAuthedAdmin(context, authedAdmin: widget.authedAdmin),
    );
  }
}
